/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.debug;

import frc.emul.mc6809.MC6809;
import frc.emul.vectrex.debug.TraceEntry;
import java.util.ArrayList;
import java.util.List;

public class TraceRecorder {
    public static final int DEFAULT_TRACE_SIZE = 2500;
    private List<TraceEntry> entries;
    private boolean warps;
    private int maxSize;
    private int oldestIdx;

    public TraceRecorder() {
        this(2500);
    }

    public TraceRecorder(int n) {
        this.setBufferMaxSize(n);
    }

    public void setBufferMaxSize(int n) {
        this.maxSize = n;
        this.entries = null;
        this.oldestIdx = 0;
        this.warps = false;
    }

    public void addTrace(MC6809 mC6809) {
        if (this.warps) {
            this.entries.get(this.oldestIdx).fill(mC6809);
            if (++this.oldestIdx >= this.maxSize) {
                this.oldestIdx = 0;
            }
        } else {
            if (this.entries == null) {
                this.entries = new ArrayList<TraceEntry>(this.maxSize);
            }
            this.entries.add(new TraceEntry(mC6809));
            this.warps = this.entries.size() == this.maxSize;
        }
    }

    public int getSize() {
        return this.entries == null ? 0 : this.entries.size();
    }

    public TraceEntry getEntry(int n) {
        if (n >= 0 && n < this.getSize()) {
            return this.entries.get((this.oldestIdx + n) % this.maxSize);
        }
        throw new IndexOutOfBoundsException("Index " + n + ", size=" + this.getSize());
    }
}

